/*
	DevSaver Web Framework
	Copyright (c) 2013-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com				
*/

var STBGlobalBTT = Object.create(STBModule.prototype);

STBGlobalBTT.name		= "GlobalBackToTop";
STBGlobalBTT.container	= "#back-to-top";
STBGlobalBTT.wait		= 600;
STBGlobalBTT.speed		= 1000;
STBGlobalBTT.animation  = "linear";
STBGlobalBTT.animateIn	= "animated fadeInRightSmall";
STBGlobalBTT.animateOut	= "animated fadeOutRightSmall";
STBGlobalBTT.isVisible  = false;

STBGlobalBTT.runOnReady = function () {
	var button = $(STBGlobalBTT.container);

	if (!button.length){
		return false;
	}

	STBGlobalBTT.animateIn = STBUtils.attrDefaultValue(button.attr("data-in"), STBGlobalBTT.animateIn);
	STBGlobalBTT.animateOut = STBUtils.attrDefaultValue(button.attr("data-out"), STBGlobalBTT.animateOut);
	STBGlobalBTT.speed = STBUtils.attrDefaultValue(button.attr("data-time"), STBGlobalBTT.speed);
	STBGlobalBTT.animation = STBUtils.attrDefaultValue(button.attr("data-anim"), STBGlobalBTT.animation);

	if (STBModuleTopintro.pageHasTopIntro()){
		STBGlobalBTT.wait += $(window).height();
	}

	button.click(function(e) {
		e.preventDefault();

		if ($("body").hasClass("is-scrolling")) {
			return false;
		}

		$("body").addClass("is-scrolling");
			
		//check if full page is enabled
		if ($(".page-wrapper").length) {
			var cont = $(".page-wrapper");
		} else {
			var cont = $("html, body");
		}


		try {
			var screens = cont.scrollTop() / $(window).height(),
				speed = parseInt(STBGlobalBTT.speed * screens);

			cont.animate(
				{
					scrollTop: 0
				},
				{	
					duration	: speed,
					easing		: STBGlobalBTT.animation,
//					queue		: false,
					complete	: function() {
											
						setTimeout(
							function() {
								$("body").removeClass("is-scrolling");
							},
							speed
						);
					}
				}
				
			);
			
		}
		catch (e){
			getStack(0,e);
		}

	});
}

STBGlobalBTT.runOnScroll = function () {

	if ($(STBGlobalBTT.container).length > 0) {

		if ($(".page-wrapper").length) {
			var cont = $(".page-wrapper");
		} else {
			var cont = $(window);
		}

		if (cont.scrollTop() > STBGlobalBTT.wait) {			
			if (!STBGlobalBTT.isVisible){
				$(STBGlobalBTT.container).show().removeClass(STBGlobalBTT.animateOut).addClass(STBGlobalBTT.animateIn);
				STBGlobalBTT.isVisible  = true;
			}
		} else {

			if (STBGlobalBTT.isVisible){
				$(STBGlobalBTT.container).removeClass(STBGlobalBTT.animateIn).addClass(STBGlobalBTT.animateOut);
				STBGlobalBTT.isVisible  = false;
			}
		}
	}
}

site.registerModule(STBGlobalBTT);